/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.state;

import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2507;

public class TempleStateRegion {
    private final String regionKey;
    private final File regionFile;
    private final ConcurrentHashMap<Long, Boolean> templeStateMap = new ConcurrentHashMap();

    public TempleStateRegion(Path basePath, String regionKey) {
        this.regionKey = regionKey;
        this.regionFile = basePath.resolve(regionKey).toFile();
        this.createRegionFileIfDoesNotExist();
    }

    public synchronized void setTempleCleared(class_2338 templePos, boolean isCleared) {
        this.templeStateMap.put(templePos.method_10063(), isCleared);
        this.createRegionFileIfDoesNotExist();
        class_2487 compoundTag = this.readRegionFile();
        compoundTag.method_10556(templePos.toString(), isCleared);
        this.writeRegionFile(compoundTag);
    }

    public synchronized boolean isTempleCleared(class_2338 templePos) {
        long templePosAsLong = templePos.method_10063();
        if (this.templeStateMap.containsKey(templePosAsLong)) {
            return this.templeStateMap.get(templePosAsLong);
        }
        this.createRegionFileIfDoesNotExist();
        boolean isCleared = false;
        class_2487 compoundTag = this.readRegionFile();
        if (compoundTag == null) {
            compoundTag = new class_2487();
            compoundTag.method_10556(templePos.toString(), isCleared);
            this.writeRegionFile(compoundTag);
        } else if (compoundTag.method_10545(templePos.toString())) {
            isCleared = compoundTag.method_10577(templePos.toString());
        } else {
            compoundTag.method_10556(templePos.toString(), isCleared);
            this.writeRegionFile(compoundTag);
        }
        this.templeStateMap.put(templePosAsLong, isCleared);
        return isCleared;
    }

    public synchronized void reset() {
        this.templeStateMap.clear();
    }

    private void writeRegionFile(class_2487 compoundTag) {
        try {
            class_2507.method_10630((class_2487)compoundTag, (Path)this.regionFile.toPath());
        }
        catch (IOException e) {
            BetterDesertTemplesCommon.LOGGER.error("Encountered error writing data to temple region file {}", (Object)this.regionKey);
            BetterDesertTemplesCommon.LOGGER.error((Object)e);
        }
    }

    private class_2487 readRegionFile() {
        try {
            return class_2507.method_10633((Path)this.regionFile.toPath());
        }
        catch (IOException e) {
            BetterDesertTemplesCommon.LOGGER.error("Encountered error reading data from temple region file {}", (Object)this.regionKey);
            BetterDesertTemplesCommon.LOGGER.error((Object)e);
            return new class_2487();
        }
    }

    private synchronized void createRegionFileIfDoesNotExist() {
        if (!this.regionFile.exists()) {
            try {
                this.regionFile.createNewFile();
                class_2507.method_10630((class_2487)new class_2487(), (Path)this.regionFile.toPath());
            }
            catch (IOException e) {
                BetterDesertTemplesCommon.LOGGER.error("Unable to create temple region file for region {}", (Object)this.regionKey);
                BetterDesertTemplesCommon.LOGGER.error((Object)e);
            }
        }
    }
}

